<?php

namespace App\Services;

use App\Exports\AgentwiseCallsReportExcel;
use App\Exports\CallMappingExport;
use App\Exports\CallsDialledReportExcel;
use App\Exports\TicketsReportExcel;
use App\Exports\ConnectedReportExport;
use App\Exports\CRMReportExport;
use App\Exports\EnquiryExcelExport;
use App\Exports\JustDialReportExport;
use App\Exports\NocallNologinExcelExport;
use App\Exports\NocallsReportExcel;
use App\Exports\NologinNocallsExport;
use App\Exports\PendingCallsExport;
use App\Exports\ReferralExportExcel;
use App\Exports\SalesAnalysisExcel;
use App\Exports\SalesReportExport;
use App\Exports\VendorCampaignExcel;

class ExcelExportService
{

    public $callsDialledReportExcel;
    public $ticketsReportExcel;
    public $justDialReportExport;
    public $callMappingExport;
    public $cRMReportExport;
    public $pendingCallsExport;
    public $salesReportExport;
    public $enquiryExcelExport;
    public $connectedReportExport;
    public $nologinNocallsExport;
    public $nocallsReportExcel;
    public $agentwiseCallsReportExcel;
    public $nocallNologinExcelExport;
    public $referralExportExcel;
    public $salesAnalysisExcel;
    public $vendorCampaignExcel;

    public function __construct(CallsDialledReportExcel $callsDialledReportExcel, TicketsReportExcel $ticketsReportExcel, JustDialReportExport $justDialReportExport, CallMappingExport $callMappingExport, CRMReportExport $cRMReportExport, PendingCallsExport $pendingCallsExport, SalesReportExport $salesReportExport, EnquiryExcelExport $enquiryExcelExport, ConnectedReportExport $connectedReportExport, NologinNocallsExport $nologinNocallsExport, NocallsReportExcel $nocallsReportExcel, AgentwiseCallsReportExcel $agentwiseCallsReportExcel, NocallNologinExcelExport $nocallNologinExcelExport, ReferralExportExcel $referralExportExcel, SalesAnalysisExcel $salesAnalysisExcel, VendorCampaignExcel $vendorCampaignExcel)
    {
        $this->callsDialledReportExcel = $callsDialledReportExcel;
        $this->ticketsReportExcel = $ticketsReportExcel;
        $this->justDialReportExport = $justDialReportExport;
        $this->callMappingExport = $callMappingExport;
        $this->cRMReportExport = $cRMReportExport;
        $this->pendingCallsExport = $pendingCallsExport;
        $this->salesReportExport = $salesReportExport;
        $this->enquiryExcelExport = $enquiryExcelExport;
        $this->connectedReportExport = $connectedReportExport;
        $this->nologinNocallsExport = $nologinNocallsExport;
        $this->nocallsReportExcel = $nocallsReportExcel;
        $this->agentwiseCallsReportExcel = $agentwiseCallsReportExcel;
        $this->nocallNologinExcelExport = $nocallNologinExcelExport;
        $this->referralExportExcel = $referralExportExcel;
        $this->salesAnalysisExcel = $salesAnalysisExcel;
        $this->vendorCampaignExcel = $vendorCampaignExcel;
    }

    public function exportExcel($request, $data)
    {
        switch ($request->type) {
            case 'calldialled-report-excel':
                return $this->callsDialledReportExcel->exportExcel($request, $data);
                break;
            case 'tickets-report-excel':
                return $this->ticketsReportExcel->exportExcel($request, $data);
                break;
            case 'justdial-report-excel':
                return $this->justDialReportExport->exportExcel($request, $data);
                break;
            case 'call-mapping':
                return $this->callMappingExport->exportExcel($data);
                break;
            case 'crm-report-excel':
                return $this->cRMReportExport->exportExcel($request, $data);
                break;
            case 'sales-report-excel':
                return $this->salesReportExport->exportExcel($request, $data);
                break;
            case 'enquiry-report-excel':
                return $this->enquiryExcelExport->exportExcel($request, $data);
                break;
            case 'pending-calls':
                return $this->pendingCallsExport->exportExcel($request, $data);
                break;
            case 'connected-report-excel':
                return $this->connectedReportExport->exportExcel($request, $data);
                break;
            case 'nologin-nocalls-report-excel':
                return $this->nologinNocallsExport->exportExcel($request, $data);
                break;
            case 'nocalls-report-excel':
                return $this->nocallsReportExcel->exportExcel($request, $data);
                break;
            case 'agentwise-calls-report-excel':
                return $this->agentwiseCallsReportExcel->exportExcel($request, $data);
                break;
            case 'nocalls-nologin-report-excel':
                return $this->nocallNologinExcelExport->exportExcel($request, $data);
                break;
            case 'referral-report-excel':
                return $this->referralExportExcel->exportExcel($request, $data);
                break;
            case 'sales-analysis-report-excel':
                return $this->salesAnalysisExcel->exportExcel($request, $data);
                break;
            case 'vendor-campaign-excel':
                return $this->vendorCampaignExcel->exportExcel($request, $data);
                break;
        }
    }
}
