<?php

namespace App\Services;

use App\Models\CRM\Masters\CrmProducts;
use App\Models\CRM\Masters\RequestCategory;
use App\Models\CRM\Masters\SubDepartments;
use App\Models\CRM\Masters\TicketCategory;
use App\Models\CRM\Masters\TicketSource;
use App\Models\CRM\Masters\CrmBrands;
use App\Models\CRMTickets;
use App\Models\Feedback;
use App\Models\FeedbackMaster;
use App\Models\Masters\AgentMapping;
use App\Models\Masters\AgentMaster;
use App\Models\Masters\ClusterMaster;
use App\Models\Masters\BranchMaster;
use App\Models\Masters\BrandMaster;
use App\Models\Masters\CallSkipReason;
use App\Models\Masters\Campaign;
use App\Models\Masters\CityMaster;
use App\Models\Masters\DesignationMaster;
use App\Models\Masters\EscalationMatrix;
use App\Models\Masters\Privilege;
use App\Models\Masters\UserMaster;
use App\Models\NumberingSystem;
use App\Models\ResolveReasons;
use App\Models\RoleMaster;
use App\Models\Transactions\BeneficiaryImport;
use App\Models\Transactions\CallMapping;
use App\Models\Transactions\CallMappingItems;
use App\Models\User;
use App\Utilities\AppClass;
use Carbon\Carbon;
use Illuminate\Http\Request;
use DB;
use Illuminate\Support\Facades\Auth;
use stdClass;

class CommonService
{
    const GET_TABLE_IGNORE_SCREES = ['privileges', 'agent-mapping'];

    public function __construct() {}

    public function updateStatus(Request $request, $id, $type, $name)
    {

        $appType = getAppTypes();
        $updateTypes = [$appType->typeActive, $appType->typeInactive];

        $isUpdated = false;

        $data = $this->getDesiredEloquent($id, $name);
        if (in_array($type, $updateTypes)) {
            $data->status = $type;
            $data->save();
            $isUpdated = true;
        } else if ($type == $appType->typeDelete) {
            $this->updateTableStatus($data, $id);
            if (in_array($name, self::GET_TABLE_IGNORE_SCREES)) {
                $data->delete();
                return true;
            }
            $data->updated_by = Auth::user()->id;
            $data->save();
            $data->delete();
            $isUpdated = true;
        } else if ($type == $appType->typeStatusUpdate) {
            // $this->updateTableStatus($data, $request);
            $isUpdated = true;
        }

        if (in_array($name, self::GET_TABLE_IGNORE_SCREES)) {
            return true;
        }

        if ($isUpdated) {
            $this->isUserUpdateModel($data, $type);
            return true;
        }
    }

    public function updateTableStatus($data, $id)
    {
        $table = $data->getTable();
        switch ($table) {
            case 'call_mapping':
                return $this->deleteCallMapping($id);
                break;
            case 'crm_tickets':
                return $this->deleteCRMCallLead($id);
                break;
        }
    }

    function deleteCallMapping($id)
    {
        $id = decrypt($id);
        $cusId = CallMappingItems::where('mapping_id', $id)->pluck('beneficiary_id')->toArray();
        if ($cusId) {
            BeneficiaryImport::whereIn('id', $cusId)->where('status', 1)->update(['agent_id' => null]);
        }
    }

    function deleteCRMCallLead($id)
    {
        $id = decrypt($id);
        if ($id) {
            BeneficiaryImport::where('crm_lead_id', $id)->delete();
        }
    }

    public function isUserUpdateModel($data, $type)
    {
        $table = $data->getTable();
        if (in_array($table, User::USER_STATUS_UPDATE_TABLES)) {
            $this->getAndUpdateUserStatus($data, $type);
        }
    }

    public function getAndUpdateUserStatus($data, $type)
    {
        $user = User::where('reference_id', $data->id)->where('role', $data->role)->first();
        if ($user) {
            $appType = getAppTypes();
            $updateTypes = [$appType->typeDelete, $appType->typeInactive];
            if (in_array($type, $updateTypes)) {
                $user->status = User::STATUS_INACTIVE;
                if ($type == $appType->typeDelete) {
                    $user->deleted_at = Carbon::now();
                }
            } else {
                $user->status = User::STATUS_ACTIVE;
                $user->deleted_at = null;
            }

            $user->save();
        }
    }

    public function getDesiredEloquent($id, $name)
    {
        $id = decrypt($id);

        switch ($name) {
            case 'district':
                $data = CityMaster::find($id);
                break;
            case 'user':
                $data = UserMaster::find($id);
                break;
            case 'feedback-master':
                $data = FeedbackMaster::find($id);
                break;
            case 'role':
                $data = RoleMaster::find($id);
                break;
            case 'designation':
                $data = DesignationMaster::find($id);
                break;
            case 'agent-master':
                $data = AgentMaster::find($id);
                break;
            case 'escalation-matrix':
                $data = EscalationMatrix::find($id);
                break;
            case 'privileges':
                $data = Privilege::where('role', $id);
                break;
            case 'agent-mapping':
                $data = AgentMapping::where('branch_id', $id);
                break;
            case 'caller':
                $data = BeneficiaryImport::find($id);
                break;
            case 'resolve-reasons':
                $data = ResolveReasons::find($id);
                break;
            case 'branch':
                $data = BranchMaster::find($id);
                break;
            case 'call-mapping':
                $data = CallMapping::find($id);
                break;
            case 'campaign':
                $data = Campaign::find($id);
                break;
            case 'call-reasons':
                $data = CallSkipReason::find($id);
                break;
            case 'brand':
                $data = BrandMaster::find($id);
                break;
            case 'cluster-master':
                $data = ClusterMaster::find($id);
                break;
            case 'crm-product':
                $data = CrmProducts::find($id);
                break;
            case 'request-category':
                $data = RequestCategory::find($id);
                break;
            case 'sub-department':
                $data = SubDepartments::find($id);
                break;
            case 'ticket-category':
                $data = TicketCategory::find($id);
                break;
            case 'ticket-source':
                $data = TicketSource::find($id);
                break;
            case 'crm-brand':
                $data = CrmBrands::find($id);
                break;
            case 'tickets':
                $data = CRMTickets::find($id);
                break;
        }
        return $data;
    }

    public function isEmailExists($request)
    {
        $email = $request->get('email');
        $id = $request->get('id');

        $sql = User::where('email', $email);

        if ($id) {
            $sql->where('id', '<>', $id);
        }
        $count = $sql->count();

        if ($count == 0) {
            return true;
        }
    }

    public function getFolderDirectory($type)
    {
        switch ($type) {
            case 'agent':
                $path = 'uploads/agent/';
                break;
            case 'sample_beneficiay_import':
                $path = 'sample_template/';
                break;
            case 'feedback-forms':
                $path = 'uploads/feedback-forms/';
                break;
            case 'call-record':
                $path = 'uploads/recordings/';
                break;
            case 'sample_resend_coupons':
                $path = 'sample_template/';
                break;
        }
        return $path;
    }

    public function downloadAttachments($type, $fileName)
    {
        $downloadFileName = $fileName;
        $folderPath = $this->getFolderDirectory($type);
        if ($type == 'call-record') {
            $feedbackId = $fileName;
            $feedback = Feedback::where('beneficiary_ref_id', $feedbackId)->first();
            if ($feedback) {
                $recordList = explode(',', $feedback->recordings);
                if (count($recordList) > 0) {
                    foreach ($recordList as $recording) {
                        if ($recording != '') {
                            $fileName = $recording;
                        }
                    }
                }
                $downloadFileName = $feedback->feedback_no . '.mp3';
            }
        }
        $filePath = $folderPath . $fileName;
        $filePath = public_path($filePath);
        if (!file_exists($filePath)) {
            $data = new AppClass();
            $data->msg = 'file backup not available in server, pls check your local system';
            $data->status = false;
            return view('templates.app-error', compact('data'));
        }
        $headers = ['Content-Type: application/pdf'];
        return response()->download($filePath, $downloadFileName, $headers);
    }

    public function generateUniqueScreenNumber($screen)
    {
        return DB::transaction(function () use ($screen) {
            $data = NumberingSystem::select('prefix_value', 'start_value', 'id')->where('screen', $screen)->sharedLock()->first();
            if ($data) {
                $code = $data->prefix_value . $data->start_value;
                $data->start_value = $data->start_value + 1;
                $data->save();
                return $code;
            }
        });
    }

    public function makeErrorResponse($msg)
    {
        $ret = new AppClass();
        $ret->status = false;
        $ret->msg = $msg;
        return $ret;
    }

    public function makeSuccessResponse($msg, $data)
    {
        $data->status = true;
        $data->msg = $msg;
        return $data;
    }

    public function getUserByToken(Request $request)
    {
        $token = PersonalAccessToken::findToken($request->bearerToken());
        $user = $token->tokenable;
        return $user;
    }

    public function saveBase64StringToFile($base64Image, $imagePath = '', $format = '.png')
    {
        $imageData = base64_decode($base64Image);
        $filename = uniqid() . $format;
        $path = storage_path($imagePath) . $filename;
        file_put_contents($path, $imageData);
        return $filename;
    }

    function formatMobileNo($mobile)
    {
        if (strlen($mobile) == 12) {
            $mobChar = substr($mobile, 0, 2);
            if (str_contains($mobChar, '91') && strlen($mobile) > 10) {
                $mobile = substr($mobile, 2, 10);
            }
        }
        if (strlen($mobile) == 13) {
            $mobChar = substr($mobile, 0, 3);
            if (str_contains($mobChar, '+91') && strlen($mobile) > 10) {
                $mobile = substr($mobile, 3, 10);
            }
        }
        if (strlen($mobile) == 11) {
            $mobChar = substr($mobile, 0, 1);
            if (str_contains($mobChar, '0') && strlen($mobile) > 10) {
                $mobile = substr($mobile, 1, 10);
            }
        }
        return $mobile;
    }

    public function coreGuzzlePostOneSignal($url, $formParams = [])
    {
        $headers = [
            'accept' => 'application/json',
            'content-type' => 'application/json',
            'Authorization' => constants('ONE_SIGNAL_API_AUTH'),
        ];

        $client = new \GuzzleHttp\Client();
        $res = $client->post($url, [
            'body' => json_encode($formParams),
            'headers' => $headers,
        ]);

        $return = new stdClass;
        $return->status = $res->getStatusCode();
        $return->data = json_decode($res->getBody()->getContents());
        return $return;
    }

    function sendWhatsAppNotification($param)
    {
        $client = new \GuzzleHttp\Client();
        $response = $client->request('POST', 'https://api.gupshup.io/sm/api/v1/msg', [
            'form_params' => [
                'channel' => 'whatsapp',
                'source' => constants('GUPSHUP_WHATSAPP_SOURCE'),
                'destination' => $param->mobile,
                'message' => json_encode($param->message),
                'src.name' => 'myapp',
                'disablePreview' => false,
                'encode' => false,
            ],
            'headers' => [
                'Content-Type' => 'application/x-www-form-urlencoded',
                'accept' => 'application/json',
                'apikey' => constants('GUPSHUP_API_KEY')
            ],
        ]);
        $data = $response->getBody();
        return $data;
    }
}
