<?php

namespace App\Services\CRM\Masters;

use App\Models\CRM\Masters\SubDepartments;
use Illuminate\Http\Request;
use Auth;

class SubDepartmentService
{

    public function __construct() {}

    public function getData()
    {
        $sql = SubDepartments::select('sub_departments.*', 'branch_master.name as branchName')
            ->join('branch_master', 'branch_master.id', 'sub_departments.branch_id')
            ->orderBy('sub_departments.id', 'desc');
        return $sql;
    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = SubDepartments::find($id);
            $data->route = route('sub-department.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
        } else {
            $data = new SubDepartments();
            $data->route = route('sub-department.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
        }
        $data->breadcrumbAction = route('sub-department.index');
        $data->breadcrumbTitle = 'Sub Department';
        return $data;
    }

    public function saveData(Request $request, $id = null)
    {
        $name = $request->has('name') ? $request->get('name') : '';
        $branch = $request->has('branch') ? $request->get('branch') : '';

        if ($id) {
            $data = SubDepartments::find($id);
            $data->updated_by = Auth::user()->id;
        } else {
            $data = new SubDepartments();
            $data->created_by = Auth::user()->id;
            $data->updated_by = Auth::user()->id;
        }

        $data->name = $name;
        $data->branch_id = $branch;
        if ($data->save()) {
            return true;
        }
    }

    public function showData($id)
    {
        return SubDepartments::find($id);
    }
}
