<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ResolveReasons extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $table = 'resolve_reasons';
    protected $primaryKey = 'id';

    const STATUS_ACTIVE = 1;
    const STATUS_INACTIVE = 0;

    const HIDDEN_IDS = [4, 5];

    const RESOLVED_REASON_BY_WORKER = 5;

    public static function getReasons()
    {
        $sql = ResolveReasons::whereNotIn('id', self::HIDDEN_IDS);
        return $sql;
    }
}
