<?php

namespace App\Http\Controllers\Transactions;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use App\Services\FeedbackService;
use App\Services\Master\PrivilegeService;
use Illuminate\Http\Request;
use App\Models\Feedback;

class ComplaintController extends Controller
{
    public $feedbackService;
    public $dataTableService;
    public $privilegeService;

    public function __construct(FeedbackService $feedbackService, DataTableService $dataTableService, PrivilegeService $privilegeService)
    {
        $this->feedbackService = $feedbackService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->feedbackService->getBenFeedbackList('complaints', $request);
            $args->edit = false;
            $args->active = false;
            $args->delete = false;
            return $this->dataTableService->getDataTable($data, $args);
        }
        $data = clone $args;
        $data->import = false;
        $data->create = false;
        $data->breadcrumbTitle = 'Complaints';
        $data->breadcrumbAction = route('complaint.index');

        return view('feedback.complaints-list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $callerId = decrypt($id);
        $data = $this->feedbackService->getFeedbackDetails($callerId);
        $data->breadcrumbName = 'Details';
        $data->breadcrumbAction = route('complaint.index');
        $data->breadcrumbTitle = 'Complaints';
        $this->feedbackService->getFileDownloadLink($data);

        $data->recordList = [];
        if ($data->recordings) {
            $data->recordList = explode(',', $data->recordings);
        }

        $data->method = 'POST';
        $data->route = route('resolveFeedback');
        $data->isResolvedAuthority = $this->feedbackService->isResolvedAuthority($data);
        $data->showComplaints = false;
        if ($data->is_compliant == Feedback::IS_COMPLIANT) {
            $data->showComplaints = true;
            $data->breadcrumbAction = route('complaint.index');
        }
        if($data->feedback && count($data->feedback) > 0){
            $this->feedbackService->removeHtmlTagsFromString($data->feedback);
        }
        $data->showRecording = false;
        return view('feedback.show', compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
