<?php

namespace App\Http\Controllers\Transactions;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use App\Services\Master\PrivilegeService;
use App\Services\Transactions\CallMappingService;
use Illuminate\Http\Request;
use Session;

class CallMappingController extends Controller
{

    public $callMappingService;
    public $dataTableService;
    public $privilegeService;

    public function __construct(CallMappingService $callMappingService, DataTableService $dataTableService, PrivilegeService $privilegeService)
    {
        $this->callMappingService = $callMappingService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->callMappingService->getData();
            $args->edit = false;
            $args->active = false;
            $args->inactive = false;
            return $this->dataTableService->getDataTable($data, $args);
        }

        $data = clone $args;
        $data->import = false;
        return view('transactions.call-mapping.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($this->callMappingService->saveData($request)) {
            Session::flash('success', 'Call Mapping created successfully');
        } else {
            Session::flash('danger', 'Call Mapping creation failed');
        }
        return redirect()->route('call-mapping.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $id = decrypt($id);
        $data = $this->callMappingService->showData($id);
        $data->breadcrumbName = 'Details';
        $data->breadcrumbAction = route('call-mapping.index');
        $data->breadcrumbTitle = 'Call Mapping';
        $data->attchmentList = [];
        if ($data->attachments) {
            $data->attchmentList = explode(',', $data->attachments);
        }
        return view('transactions.call-mapping.show', compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->callMappingService->isNew($id);
        return view('transactions.call-mapping.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->callMappingService->saveData($request, $id)) {
            Session::flash('success', 'Call Mapping updated successfully');
        } else {
            Session::flash('danger', 'Call Mapping updated failed');
        }
        return redirect()->route('call-mapping.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function getAgents(Request $request)
    {
        return $this->callMappingService->getAgents($request);
    }

    public function getProducts(Request $request)
    {
        return $this->callMappingService->getProducts($request);
    }

    public function getCustomerList(Request $request)
    {
        return $this->callMappingService->getCustomerList($request);
    }
}
