<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use Illuminate\Http\Request;
use App\Services\Master\PrivilegeService;
use App\Services\Reports\ResolvedReportService;

class ResolvedReportController extends Controller
{
    public $privilegeService;
    public $dataTableService;
    public $resolvedReportService;

    public function __construct(PrivilegeService $privilegeService, DataTableService $dataTableService, ResolvedReportService $resolvedReportService)
    {
        $this->privilegeService = $privilegeService;
        $this->dataTableService = $dataTableService;
        $this->resolvedReportService = $resolvedReportService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails('reports');
        if ($request->ajax()) {
            $data = $this->resolvedReportService->getData($request);
            $args->showTimeStamp = true;
            return $this->dataTableService->getDataTableReports($data, $args);
        }
        $data = clone $args;
        $data->action = route('navigateReport');
        $data->method = 'POST';
        return view('reports.resolved-report', compact('data'));
    }
}
