<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use Illuminate\Http\Request;
use App\Services\Master\PrivilegeService;
use App\Services\Reports\OngoingCallsService;
use Session;

class OngoingCallsController extends Controller
{
    public $privilegeService;
    public $dataTableService;
    public $ongoingCallsService;

    public function __construct(PrivilegeService $privilegeService, DataTableService $dataTableService, OngoingCallsService $ongoingCallsService)
    {
        $this->privilegeService = $privilegeService;
        $this->dataTableService = $dataTableService;
        $this->ongoingCallsService = $ongoingCallsService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->ongoingCallsService->getData($request);
            $args->view = true;
            $args->showAction = true;
            return $this->dataTableService->getDataTableReports($data, $args);
        }
        $data = clone $args;
        $data->create = false;
        $data->import = false;
        $data->action = route('navigateReport');
        $data->method = 'POST';
        return view('reports.ongoing-calls', compact('data'));
    }

    function updateCallStatus(Request $request, $id)
    {
        if ($this->ongoingCallsService->updateCallStatus($request, $id)) {
            Session::flash('success', 'Call status updated successfully');
        } else {
            Session::flash('danger', 'Call status updated failed');
        }
        return redirect()->route('ongoing-calls');
    }
}
