<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use Illuminate\Http\Request;
use App\Services\Master\PrivilegeService;
use App\Services\Reports\EmployeeSummaryService;

class EmployeeSummaryController extends Controller
{
    public $privilegeService;
    public $dataTableService;
    public $employeeSummaryService;

    public function __construct(PrivilegeService $privilegeService, DataTableService $dataTableService, EmployeeSummaryService $employeeSummaryService)
    {
        $this->privilegeService = $privilegeService;
        $this->dataTableService = $dataTableService;
        $this->employeeSummaryService = $employeeSummaryService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = $this->privilegeService->getPrivilegeDetails();
        $data->create = false;
        $data->import = false;
        $data->action = route('navigateReport');
        $data->method = 'POST';
        return view('reports.employee-summary', compact('data'));
    }

    function getEmployeeData(Request $request)
    {
        $result = $this->employeeSummaryService->getData($request);
        $html = view('reports.employee-summary-table', compact('result'))->render();
        return response()->json(['html' => $html]);
    }
}
