<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use Illuminate\Http\Request;
use App\Services\Master\PrivilegeService;
use App\Services\Reports\CallsDialledService;

class CallsDialledController extends Controller
{
    public $privilegeService;
    public $dataTableService;
    public $callsDialledService;

    public function __construct(PrivilegeService $privilegeService, DataTableService $dataTableService, CallsDialledService $callsDialledService)
    {
        $this->privilegeService = $privilegeService;
        $this->dataTableService = $dataTableService;
        $this->callsDialledService = $callsDialledService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            return $this->callsDialledService->getData($request);
        }
        $data = clone $args;
        $data->create = false;
        $data->import = false;
        $data->action = route('navigateReport');
        $data->method = 'POST';
        return view('reports.calls-dialled-report', compact('data'));
    }

    function viewTranscript(Request $request, $id = null)
    {
        $id = decrypt($request->id);
        $data = $this->callsDialledService->viewTranscript($id);
        $data->breadcrumbName = 'Details';
        $data->breadcrumbAction = route('calls-dialled');
        $data->breadcrumbTitle = 'Calls Dialled';
        return view('reports.view-transcript', compact('data'));
    }
}
