<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use App\Services\Master\PrivilegeService;
use App\Services\ReferralCampaignService;
use Illuminate\Http\Request;
use Session;

class ReferralCampaignController extends Controller
{

    public $referralCampaignService;
    public $dataTableService;
    public $privilegeService;

    public function __construct(ReferralCampaignService $referralCampaignService, DataTableService $dataTableService, PrivilegeService $privilegeService)
    {
        $this->referralCampaignService = $referralCampaignService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->referralCampaignService->getData();
            $args->delete = false;
            $args->active = false;
            $args->inactive = false;
            $args->view = false;
            return $this->dataTableService->getDataTable($data, $args);
        }
        $data = clone $args;
        $data->import = false;
        $data->create = false;

        return view('campaign.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($this->referralCampaignService->saveData($request)) {
            Session::flash('success', 'Campaign created successfully');
        } else {
            Session::flash('danger', 'Campaign creation failed');
        }
        return redirect()->route('referral-campaign.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $id = decrypt($id);
        $data = $this->referralCampaignService->showData($id);
        $data->breadcrumbName = 'Details';
        $data->breadcrumbAction = route('referral-campaign.index');
        $data->breadcrumbTitle = 'Campaign';
        return view('campaign.show', compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->referralCampaignService->isNew($id);
        return view('campaign.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->referralCampaignService->saveData($request, $id)) {
            Session::flash('success', 'Campaign updated successfully');
        } else {
            Session::flash('danger', 'Campaign updated failed');
        }
        return redirect()->route('referral-campaign.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
