<?php

namespace App\Http\Controllers\Masters;

use App\Services\DataTableService;
use Illuminate\Http\Request;
use Session;
use App\Http\Controllers\Controller;
use App\Services\Master\PrivilegeService;
use App\Services\Master\SettingsService;

class SettingsController extends Controller
{

    public $settingsService;
    public $dataTableService;
    public $privilegeService;

    public function __construct(SettingsService $settingsService, DataTableService $dataTableService, PrivilegeService $privilegeService)
    {
        $this->settingsService = $settingsService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        return $this->edit();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {}

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->settingsService->isNew($id);
        return view('master.settings-form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->settingsService->saveData($request, $id)) {
            Session::flash('success', 'Settings updated successfully');
        } else {
            Session::flash('danger', 'Settings update failed');
        }
        return redirect()->route('settings.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    function deletePendingCalls(Request $request) {
        $response = $this->settingsService->deletePendingCalls($request);
        return response()->json($response);
    }

    function reallocateCalls(Request $request) {
        $response = $this->settingsService->reallocateCalls($request);
        return response()->json($response);
    }
}
