<?php

namespace App\Http\Controllers\Masters;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use App\Services\Master\PrivilegeService;
use App\Services\Master\RoleService;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Session;

class RoleController extends Controller
{

    public $roleService;
    public $dataTableService;
    public $privilegeService;

    public function __construct(RoleService $roleService, DataTableService $dataTableService, PrivilegeService $privilegeService)
    {
        $this->roleService = $roleService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->roleService->getData();
            $args->view = false;
            return $this->dataTableService->getDataTable($data, $args);
        }
        
        $data = clone $args;
        $data->import = false;

        return view('master.role.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($this->roleService->saveData($request)) {
            Session::flash('success', 'Role created successfully');
        } else {
            Session::flash('danger', 'Role creation failed');
        }
        return redirect()->route('role.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->roleService->isNew($id);
        return view('master.role.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->roleService->saveData($request, $id)) {
            Session::flash('success', 'Role updated successfully');
        } else {
            Session::flash('danger', 'Role updated failed');
        }
        return redirect()->route('role.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
