<?php

namespace App\Http\Controllers\Masters;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use App\Services\Master\EscalationMatrixService;
use App\Services\Master\PrivilegeService;
use Illuminate\Http\Request;
use Session;

class EscalationMatrixController extends Controller
{

    public $agentService;
    public $dataTableService;
    public $privilegeService;

    public function __construct(EscalationMatrixService $escalationMatrixService, DataTableService $dataTableService, PrivilegeService $privilegeService)
    {
        $this->escalationMatrixService = $escalationMatrixService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->escalationMatrixService->getData();
            return $this->dataTableService->getDataTable($data, $args);
        }
        $data = clone $args;
        $data->import = false;

        return view('master.escalation.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $this->escalationMatrixService->saveData($request);
        if ($data === true) {
            Session::flash('success', 'Escalation level created successfully');
        } else if ($data == 'exists') {
            Session::flash('danger', 'Escalation level already exists. use update option');
        } else {
            Session::flash('danger', 'Escalation level creation failed');
        }
        return redirect()->route('escalation-matrix.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $id = decrypt($id);
        $data = $this->escalationMatrixService->showData($id);
        $data->breadcrumbName = 'Details';
        $data->breadcrumbAction = route('escalation-matrix.index');
        $data->breadcrumbTitle = 'Escalation Matrix';
        return view('master.escalation.show', compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->escalationMatrixService->isNew($id);
        return view('master.escalation.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->escalationMatrixService->saveData($request, $id)) {
            Session::flash('success', 'Escalation level updated successfully');
        } else {
            Session::flash('danger', 'Escalation level updated failed');
        }
        return redirect()->route('escalation-matrix.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
