<?php

namespace App\Http\Controllers\Masters;

use App\Models\CityMaster;
use App\Services\DataTableService;
use App\Services\Master\DistrictService;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Session;
use App\Http\Controllers\Controller;
use App\Services\Master\PrivilegeService;

class DistrictController extends Controller
{

    public $districtService;
    public $dataTableService;
    public $privilegeService;

    public function __construct(DistrictService $districtService, DataTableService $dataTableService, PrivilegeService $privilegeService)
    {
        $this->districtService = $districtService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->districtService->getDistrictData();
            $args->view = false;
            return $this->dataTableService->getDataTable($data, $args);
        }
        $data = clone $args;
        $data->import = false;

        return view('master.district.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($this->districtService->saveData($request)) {
            Session::flash('success', 'District created successfully');
        } else {
            Session::flash('danger', 'District creation failed');
        }
        return redirect()->route('district.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id=null)
    {
        $data = $this->districtService->isNew($id);
        return view('master.district.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->districtService->saveData($request, $id)) {
            Session::flash('success', 'District updated successfully');
        } else {
            Session::flash('danger', 'District updated failed');
        }
        return redirect()->route('district.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        
    }

}
