<?php

namespace App\Http\Controllers\Masters;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use App\Services\Master\BranchService;
use App\Services\Master\PrivilegeService;
use Illuminate\Http\Request;
use Session;

class BranchController extends Controller
{

    public $branchService;
    public $dataTableService;
    public $privilegeService;

    public function __construct(BranchService $branchService, DataTableService $dataTableService, PrivilegeService $privilegeService)
    {
        $this->branchService = $branchService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->branchService->getData();
            return $this->dataTableService->getDataTable($data, $args);
        }

        $data = clone $args;
        $data->import = false;
        return view('master.branch.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($this->branchService->saveData($request)) {
            Session::flash('success', 'Branch created successfully');
        } else {
            Session::flash('danger', 'Branch creation failed');
        }
        return redirect()->route('branch.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $id = decrypt($id);
        $data = $this->branchService->show($id);
        $data->breadcrumbName = 'Details';
        $data->breadcrumbAction = route('branch.index');
        $data->breadcrumbTitle = 'Branch';
        return view('master.branch.show', compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->branchService->isNew($id);
        return view('master.branch.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->branchService->saveData($request, $id)) {
            Session::flash('success', 'Branch updated successfully');
        } else {
            Session::flash('danger', 'Branch updated failed');
        }
        return redirect()->route('branch.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
