<?php

namespace App\Http\Controllers\Masters;

use App\Http\Controllers\Controller;
use App\Services\DataTableService;
use App\Services\Master\AwcService;
use App\Services\Master\PrivilegeService;
use Illuminate\Http\Request;
use Session;

class AwcController extends Controller
{

    public $awcService;
    public $dataTableService;
    public $privilegeService;

    public function __construct(AwcService $awcService, DataTableService $dataTableService, PrivilegeService $privilegeService)
    {
        $this->awcService = $awcService;
        $this->dataTableService = $dataTableService;
        $this->privilegeService = $privilegeService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();

        if ($request->ajax()) {
            $data = $this->awcService->getData();
            $args->view = false;
            return $this->dataTableService->getDataTable($data, $args);
        }

        $data = clone $args;
        $data->import = false;

        return view('master.awc.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($this->awcService->saveData($request)) {
            Session::flash('success', 'AWC created successfully');
        } else {
            Session::flash('danger', 'AWC creation failed');
        }
        return redirect()->route('awc-master.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->awcService->isNew($id);
        return view('master.awc.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->awcService->saveData($request, $id)) {
            Session::flash('success', 'AWC updated successfully');
        } else {
            Session::flash('danger', 'AWC updated failed');
        }
        return redirect()->route('awc-master.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
