<?php

namespace App\Http\Controllers;

use App\Services\GoogleSheetService;

class GoogleSheetController extends Controller
{
    protected $googleSheetService;

    public function __construct(GoogleSheetService $googleSheetService)
    {
        $this->googleSheetService = $googleSheetService;
    }

    public function readData()
    {
        $data = $this->googleSheetService->readSheet('Sheet1');
        dd($data);
        return response()->json($data);
    }

    public function addRow()
    {
        $newRow = ['John Doe', 'johndoe@example.com', 'Laravel'];
        $this->googleSheetService->appendRow('Sheet1!A1:C1', $newRow);
        return response()->json(['message' => 'Row added successfully']);
    }

    public function updateRow(Request $request)
    {
        $rowNumber = $request->input('row'); // Example: 2 for updating row 2
        $updatedData = $request->input('data'); // Example: ['John Doe', 'john@example.com', 'Laravel Developer']

        // Define the range (e.g., "Sheet1!A$rowNumber:C$rowNumber")
        $range = "Sheet1!A{$rowNumber}:C{$rowNumber}";

        $this->googleSheetService->updateRow($range, $updatedData);

        return response()->json(['message' => 'Row updated successfully']);
    }
}
