<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Services\ExcelCampaignService;
use Illuminate\Http\Request;

class ExcelCampaignController extends Controller
{
    private $excelCampaignService;
    public function __construct(ExcelCampaignService $excelCampaignService)
    {
        $this->excelCampaignService = $excelCampaignService;
    }


    function excelCampaignList(Request $request)
    {
        $data = $this->excelCampaignService->excelCampaignList($request);
        return $data;
    }

    function assignCampaignLeads(Request $request)
    {
        $data = $this->excelCampaignService->assignCampaignLeads($request);
        if ($data->status) {
            return sendResponse($data, $data->msg);
        }
        return sendError($data->msg);
    }
}
