<?php

namespace App\Http\Controllers\CRM\Masters;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\CRM\Masters\TicketsService;
use App\Services\DataTableService;
use App\Services\Master\PrivilegeService;
use Session;

class TicketsContoller extends Controller
{

    public $privilegeService;
    public $dataTableService;
    public $ticketsService;

    public function __construct(PrivilegeService $privilegeService, DataTableService $dataTableService, TicketsService $ticketsService)
    {
        $this->privilegeService = $privilegeService;
        $this->dataTableService = $dataTableService;
        $this->ticketsService = $ticketsService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();
        if ($request->ajax()) {
            $data = $this->ticketsService->getData($request);
            $args->showFiles = true;
            $args->wrapTxt = true;
            $args->active = false;
            $args->inactive = false;
            return $this->dataTableService->getDataTable($data, $args);
        }
        $data = clone $args;
        $data->import = false;
        $data->action = route('navigateReport');
        $data->method = 'POST';
        $data->userList = $this->ticketsService->getBranchUsers();
        return view('crm.masters.tickets.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($this->ticketsService->saveData($request)) {
            Session::flash('success', 'Ticket created successfully');
        } else {
            Session::flash('danger', 'Ticket created failed');
        }
        return redirect()->route('tickets.create');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $id = decrypt($id);
        $data = $this->ticketsService->showData($id);
        $data->breadcrumbName = 'Details';
        $data->breadcrumbAction = route('tickets.index');
        $data->breadcrumbTitle = 'Tickets';
        return view('crm.masters.tickets.show', compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->ticketsService->isNew($id);
        return view('crm.masters.tickets.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->ticketsService->saveData($request, $id)) {
            Session::flash('success', 'Ticket updated successfully');
        } else {
            Session::flash('danger', 'Ticket updated failed');
        }
        return redirect()->route('tickets.create');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    function getSalesDetails(Request $request)
    {
        $data = $this->ticketsService->getSalesDetails($request);
        return response()->json($data);
    }

    function getSubDept(Request $request)
    {
        $data = $this->ticketsService->getSubDept($request);
        return response()->json($data);
    }

    function transferCloseLeads(Request $request)
    {
        $data = $this->ticketsService->transferCloseLeads($request);
        return response()->json($data);
    }

    public function updateTicket(Request $request)
    {
        if ($this->ticketsService->updateTicket($request)) {
            Session::flash('success', 'Ticket updated successfully');
        } else {
            Session::flash('danger', 'Ticket updated failed');
        }
        return redirect()->route('tickets.index');
    }
}
