<?php

namespace App\Http\Controllers\CRM\Masters;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\CRM\Masters\SubDepartmentService;
use App\Services\DataTableService;
use App\Services\Master\PrivilegeService;
use Session;

class SubDepartmentController extends Controller
{

    public $privilegeService;
    public $dataTableService;
    public $subDepartmentService;

    public function __construct(PrivilegeService $privilegeService, DataTableService $dataTableService, SubDepartmentService $subDepartmentService)
    {
        $this->privilegeService = $privilegeService;
        $this->dataTableService = $dataTableService;
        $this->subDepartmentService = $subDepartmentService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();
        if ($request->ajax()) {
            $data = $this->subDepartmentService->getData();
            $args->view = false;
            return $this->dataTableService->getDataTable($data, $args);
        }
        $data = clone $args;
        $data->import = false;
        return view('crm.masters.sub-department.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($this->subDepartmentService->saveData($request)) {
            Session::flash('success', 'Sub department created successfully');
        } else {
            Session::flash('danger', 'Sub department created failed');
        }
        return redirect()->route('sub-department.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $id = decrypt($id);
        $data = $this->subDepartmentService->showData($id);
        $data->breadcrumbName = 'Details';
        $data->breadcrumbAction = route('sub-department.index');
        $data->breadcrumbTitle = 'Sub department';
        return view('crm.masters.product.show', compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->subDepartmentService->isNew($id);
        return view('crm.masters.sub-department.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->subDepartmentService->saveData($request, $id)) {
            Session::flash('success', 'Sub department updated successfully');
        } else {
            Session::flash('danger', 'Sub department updated failed');
        }
        return redirect()->route('sub-department.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
