<?php

namespace App\Http\Controllers\CRM\Masters;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\CRM\Masters\RequestCategoryService;
use App\Services\DataTableService;
use App\Services\Master\PrivilegeService;
use Session;

class RequestCategoryController extends Controller
{

    public $privilegeService;
    public $dataTableService;
    public $requestCategoryService;

    public function __construct(PrivilegeService $privilegeService, DataTableService $dataTableService, RequestCategoryService $requestCategoryService)
    {
        $this->privilegeService = $privilegeService;
        $this->dataTableService = $dataTableService;
        $this->requestCategoryService = $requestCategoryService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();
        if ($request->ajax()) {
            $data = $this->requestCategoryService->getData();
            $args->view = false;
            return $this->dataTableService->getDataTable($data, $args);
        }
        $data = clone $args;
        $data->import = false;
        return view('crm.masters.request-category.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($this->requestCategoryService->saveData($request)) {
            Session::flash('success', 'Request Category created successfully');
        } else {
            Session::flash('danger', 'Request Category created failed');
        }
        return redirect()->route('request-category.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $id = decrypt($id);
        $data = $this->requestCategoryService->showData($id);
        $data->breadcrumbName = 'Details';
        $data->breadcrumbAction = route('request-categoryindex');
        $data->breadcrumbTitle = 'Request Category';
        return view('crm.masters.product.show', compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->requestCategoryService->isNew($id);
        return view('crm.masters.request-category.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->requestCategoryService->saveData($request, $id)) {
            Session::flash('success', 'Request Category updated successfully');
        } else {
            Session::flash('danger', 'Request Category updated failed');
        }
        return redirect()->route('request-category.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
