<?php

namespace App\Http\Controllers\CRM\Masters;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\CRM\Masters\ProductService;
use App\Services\DataTableService;
use App\Services\Master\PrivilegeService;
use Session;
use App\Utilities\AppClass;

class ProductController extends Controller
{

    public $privilegeService;
    public $dataTableService;
    public $productService;

    public function __construct(PrivilegeService $privilegeService, DataTableService $dataTableService, ProductService $productService)
    {
        $this->privilegeService = $privilegeService;
        $this->dataTableService = $dataTableService;
        $this->productService = $productService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $args = $this->privilegeService->getPrivilegeDetails();
        if ($request->ajax()) {
            $data = $this->productService->getData();
            return $this->dataTableService->getDataTable($data, $args);
        }
        $data = clone $args;
        $data->import = false;

        return view('crm.masters.product.list', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return $this->edit();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($this->productService->saveData($request)) {
            Session::flash('success', 'Product created successfully');
        } else {
            Session::flash('danger', 'Product created failed');
        }
        return redirect()->route('crm-product.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $id = decrypt($id);
        $data = $this->productService->showData($id);
        $data->breadcrumbName = 'Details';
        $data->breadcrumbAction = route('crm-product.index');
        $data->breadcrumbTitle = 'Products';
        return view('crm.masters.product.show', compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id = null)
    {
        $data = $this->productService->isNew($id);
        return view('crm.masters.product.form', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if ($this->productService->saveData($request, $id)) {
            Session::flash('success', 'Product updated successfully');
        } else {
            Session::flash('danger', 'Product updated failed');
        }
        return redirect()->route('crm-product.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
