<?php

namespace App\Exports;

use Log;
use PhpOffice\PhpSpreadsheet\Reader\Exception;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xls;
use Carbon\Carbon;

class VendorCampaignExcel
{

    public $excelEntities;

    public function __construct(ExcelEntities $excelEntities)
    {
        $this->excelEntities = $excelEntities;
    }

    public function exportExcel($request, $data)
    {

        ob_start();
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '4000M');

        try {

            $spreadSheet = new Spreadsheet();

            $sheet = $spreadSheet->getActiveSheet();

            $bold = $this->excelEntities->styleBold();
            $heading = $this->excelEntities->styleHeading1();

            $sheet->setCellValue('A1', 'Date Range : ' . Carbon::parse($request->fromDate)->format('d/m/Y') . ' to ' . Carbon::parse($request->toDate)->format('d/m/Y'));
            $sheet->setCellValue('A2', 'Cluster : ' . $request->clusterLabel);
            $sheet->setCellValue('A3', 'Branch : ' . $request->branchLabel);
            $sheet->setCellValue('A4', 'Agent : ' . $request->agentLabel);

            $sheet->setCellValue('A5', 'Cluster');
            $sheet->setCellValue('B5', 'Branch');
            $sheet->setCellValue('C5', 'Date & Time');
            $sheet->setCellValue('D5', 'Customer Name');
            $sheet->setCellValue('E5', 'Mobile');
            $sheet->setCellValue('F5', 'Agent Name');
            $sheet->setCellValue('G5', 'Read Status');

            $sheet->getStyle('A1')->applyFromArray($heading);
            $sheet->getStyle('A2')->applyFromArray($heading);
            $sheet->getStyle('A3')->applyFromArray($heading);
            $sheet->getStyle('A4')->applyFromArray($heading);

            $sheet->getStyle('A5:G5')->applyFromArray($bold);

            $rows = 6;

            foreach ($data as $key => $val) {
                $customerName = preg_replace('/[^\x20-\x7E]/', '', $val->name);
                $sheet->setCellValue('A' . $rows, $val->clusterName);
                $sheet->setCellValue('B' . $rows, $val->branchName);
                $sheet->setCellValue('C' . $rows, AppDateTimeFormat($val->date_created));
                $sheet->setCellValue('D' . $rows, $customerName);
                $sheet->setCellValue('E' . $rows, $val->phone);
                $sheet->setCellValue('F' . $rows, $val->agentName);
                $sheet->setCellValue('G' . $rows, $val->readStatus);
                $rows++;
            }

            $Excel_writer = new Xls($spreadSheet);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="vendor-campaign-report.xls"');
            header('Cache-Control: max-age=0');
            ob_end_clean();
            $Excel_writer->save('php://output');
            exit();
        } catch (Exception $e) {
            Log::info('vendor-campaign report export error : ' . $e);
        }
    }
}
