<?php

namespace App\Exports;

use Log;
use PhpOffice\PhpSpreadsheet\Reader\Exception;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xls;

class TestDataExport
{

    public $excelEntities;

    public function __construct(ExcelEntities $excelEntities)
    {
        $this->excelEntities = $excelEntities;
    }

    public function exportExcel($data)
    {

        ob_start();
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '4000M');

        try {

            $spreadSheet = new Spreadsheet();

            $sheet = $spreadSheet->getActiveSheet();

            $bold = $this->excelEntities->styleBold();
            $heading = $this->excelEntities->styleHeading1();

            $sheet->setCellValue('A1', 'Ben Name');
            $sheet->setCellValue('B1', 'Mobile');
            $sheet->setCellValue('C1', 'Scheme');
            $sheet->setCellValue('D1', 'Program');
            $sheet->setCellValue('E1', 'District');
            $sheet->setCellValue('F1', 'Block');
            $sheet->setCellValue('G1', 'Sector');
            $sheet->setCellValue('H1', 'AWC');
            $sheet->setCellValue('I1', 'Question');
            $sheet->setCellValue('J1', 'Answer');
            // $sheet->setCellValue('K1', 'Count');
            $sheet->setCellValue('K1', 'Type');
            $sheet->setCellValue('L1', 'Resolved Status');

            $sheet->getStyle('A1:L1')->applyFromArray($bold);

            $rows = 2;

            foreach ($data as $key => $val) {

                $sheet->setCellValue('A' . $rows, $val->parent_name);
                $sheet->setCellValue('B' . $rows, $val->mobile_number);
                $sheet->setCellValue('C' . $rows, $val->scheme);
                $sheet->setCellValue('D' . $rows, $val->program);
                $sheet->setCellValue('E' . $rows, $val->district);
                $sheet->setCellValue('F' . $rows, $val->block);
                $sheet->setCellValue('G' . $rows, $val->sector);
                $sheet->setCellValue('H' . $rows, $val->awc);
                $sheet->setCellValue('I' . $rows, removeHtmlTags($val->label));
                $sheet->setCellValue('J' . $rows, removeHtmlTags($val->value));
                // $sheet->setCellValue('K' . $rows, $val->count);
                $sheet->setCellValue('K' . $rows, $val->feedbackStatus);
                $sheet->setCellValue('L' . $rows, $val->resolvedStatus);
                $rows++;
            }

            $Excel_writer = new Xls($spreadSheet);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="beneficiary.xls"');
            header('Cache-Control: max-age=0');
            ob_end_clean();
            $Excel_writer->save('php://output');
            exit();
        } catch (Exception $e) {

            Log::info('test excel export error : ' . $e);
        }
    }
}
