<?php

namespace App\Exports;

use Log;
use PhpOffice\PhpSpreadsheet\Reader\Exception;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xls;
use Carbon\Carbon;

class SalesAnalysisExcel
{

    public $excelEntities;

    public function __construct(ExcelEntities $excelEntities)
    {
        $this->excelEntities = $excelEntities;
    }

    function populateRow($sheet, $rowIndex, $label, $data, $columnKey)
    {
        $colIndex = 2;
        $sheet->setCellValueByColumnAndRow(1, $rowIndex, $label);
        foreach ($data as $item) {
            $sheet->setCellValueByColumnAndRow($colIndex, $rowIndex, returnZeroWhenEmptyOrNull($item->$columnKey));
            $colIndex++;
        }
    }

    public function exportExcel($request, $data)
    {
        ob_start();
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '4000M');

        try {

            $spreadSheet = new Spreadsheet();

            $sheet = $spreadSheet->getActiveSheet();

            $bold = $this->excelEntities->styleBold();
            $heading = $this->excelEntities->styleHeading1();

            $sheet->setCellValue('A1', 'Date : ' . Carbon::parse($request->date)->format('d/m/Y'));
            $sheet->setCellValue('A2', 'Branch : ' . $request->branchLabel);

            //table 1
            $colIndex = 2;
            $sheet->setCellValueByColumnAndRow(1, 3, 'Sales Analysis');
            foreach ($data->tableHeader as $header) {
                $sheet->setCellValueByColumnAndRow($colIndex, 3, $header);
                $colIndex++;
            }

            //populate rows
            $this->populateRow($sheet, 4, 'Sales Converted On Connected Calls', $data->tableOne, 'salesConvOnConnCalls');
            $this->populateRow($sheet, 5, 'Total Allocated Calls', $data->tableOne, 'allocatedCalls');
            $this->populateRow($sheet, 6, 'Connected Calls Ratio %', $data->tableOne, 'connCallRatio');
            $this->populateRow($sheet, 7, 'If Connected Calls With Total Allocated', $data->tableOne, 'connTotalAll');
            $this->populateRow($sheet, 8, 'Same Sales Conversion On Allocated', $data->tableOne, 'salesConversion');
            $this->populateRow($sheet, 9, 'Average Sales Price', $data->tableOne, 'avgSalesPrice');
            $this->populateRow($sheet, 10, 'If Sales Converted On Allocated Calls', $data->tableOne, 'salesConvertedAllocatedCalls');

            //table 2
            $colIndex = 2;
            $sheet->setCellValueByColumnAndRow(1, 13, 'Last 2 Months');
            $text = '';
            foreach ($data->tableHeader as $index => $header) {
                $text .= $header;
                if ($index !== count($data->tableHeader) - 1) {
                    $text .= ' & ';
                }
            }
            $sheet->setCellValueByColumnAndRow($colIndex, 13, $text);
            $colIndex++;

            $colIndex = 4;
            foreach ($data->tableHeader as $header) {
                $sheet->setCellValueByColumnAndRow($colIndex, 13, $header);
                $colIndex++;
                $colIndex++;
            }

            $sheet->mergeCells('B13:C13');
            $sheet->mergeCells('D13:E13');
            $sheet->mergeCells('F13:G13');

            $sheet->setCellValueByColumnAndRow(1, 14, 'Conversions');
            $sheet->setCellValueByColumnAndRow(2, 14, 'Sales Qty');
            $sheet->setCellValueByColumnAndRow(3, 14, 'Sales Value');
            $sheet->setCellValueByColumnAndRow(4, 14, 'Sales Qty');
            $sheet->setCellValueByColumnAndRow(5, 14, 'Sales Value');
            $sheet->setCellValueByColumnAndRow(6, 14, 'Sales Qty');
            $sheet->setCellValueByColumnAndRow(7, 14, 'Sales Value');

            $sheet->setCellValueByColumnAndRow(1, 15, 'Total Sales');
            $colIndex = 2;
            foreach ($data->tableTwo as $value) {
                $sheet->setCellValueByColumnAndRow($colIndex, 15, returnZeroWhenEmptyOrNull($value->totalSales->qty));
                $colIndex++;
                $sheet->setCellValueByColumnAndRow($colIndex, 15, returnZeroWhenEmptyOrNull($value->totalSales->value));
                $colIndex++;
            }

            $sheet->setCellValueByColumnAndRow(1, 16, 'Connected Calls');
            $colIndex = 2;
            foreach ($data->tableTwo as $value) {
                $sheet->setCellValueByColumnAndRow($colIndex, 16, returnZeroWhenEmptyOrNull($value->connCalls->qty));
                $colIndex++;
                $sheet->setCellValueByColumnAndRow($colIndex, 16, returnZeroWhenEmptyOrNull($value->connCalls->value));
                $colIndex++;
            }

            $sheet->setCellValueByColumnAndRow(1, 17, 'Not Connected Calls');
            $colIndex = 2;
            foreach ($data->tableTwo as $value) {
                $sheet->setCellValueByColumnAndRow($colIndex, 17, returnZeroWhenEmptyOrNull($value->notConnCalls->qty));
                $colIndex++;
                $sheet->setCellValueByColumnAndRow($colIndex, 17, returnZeroWhenEmptyOrNull($value->notConnCalls->value));
                $colIndex++;
            }

            $Excel_writer = new Xls($spreadSheet);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="sales-analysis-report.xls"');
            header('Cache-Control: max-age=0');
            ob_end_clean();
            $Excel_writer->save('php://output');
            exit();
        } catch (Exception $e) {
            Log::info('referral report export error : ' . $e);
        }
    }
}
