<?php

namespace App\Exports;

use Log;
use PhpOffice\PhpSpreadsheet\Reader\Exception;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xls;
use Carbon\Carbon;

class ReferralExportExcel
{

    public $excelEntities;

    public function __construct(ExcelEntities $excelEntities)
    {
        $this->excelEntities = $excelEntities;
    }

    public function exportExcel($request, $data)
    {
        ob_start();
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '4000M');

        try {

            $spreadSheet = new Spreadsheet();

            $sheet = $spreadSheet->getActiveSheet();

            $bold = $this->excelEntities->styleBold();
            $heading = $this->excelEntities->styleHeading1();

            $sheet->setCellValue('A1', 'Date : ' . Carbon::parse($request->date)->format('d/m/Y'));
            $sheet->setCellValue('A2', 'Branch : ' . $request->branchLabel);

            $sheet->setCellValue('A3', 'Branch');
            $sheet->setCellValue('B3', 'Sales Date');
            $sheet->setCellValue('C3', 'Customer Name');
            $sheet->setCellValue('D3', 'Mobile');
            $sheet->setCellValue('E3', 'Purchase Amount');
            $sheet->setCellValue('F3', 'Voucher Code');
            $sheet->setCellValue('G3', 'Voucher Amount');
            $sheet->setCellValue('H3', 'Referral Voucher Code');
            $sheet->setCellValue('I3', 'Referral Voucher Amount');
            $sheet->setCellValue('J3', 'Claimed Branch');
            $sheet->setCellValue('K3', 'Sales Date');
            $sheet->setCellValue('L3', 'Referred To Name');
            $sheet->setCellValue('M3', 'Referred To Mobile');
            $sheet->setCellValue('N3', 'Purchase Amount');

            $sheet->getStyle('A1')->applyFromArray($heading);
            $sheet->getStyle('A2')->applyFromArray($heading);

            $sheet->getStyle('A3:N3')->applyFromArray($bold);

            $rows = 4;

            foreach ($data as $key => $val) {

                $sheet->setCellValue('A' . $rows, $val->branchName);
                $sheet->setCellValue('B' . $rows, $val->salesDate);
                $sheet->setCellValue('C' . $rows, $val->customer_name);
                $sheet->setCellValue('D' . $rows, $val->mobile);
                $sheet->setCellValue('E' . $rows, $val->amount);
                $sheet->setCellValue('F' . $rows, $val->coupon_code);
                $sheet->setCellValue('G' . $rows, $val->coupon_amount);
                $sheet->setCellValue('H' . $rows, $val->voucher_code);
                $sheet->setCellValue('I' . $rows, $val->referralAmount);
                $sheet->setCellValue('J' . $rows, $val->claimedBranchName);
                $sheet->setCellValue('K' . $rows, $val->ReferredSalesDate);
                $sheet->setCellValue('L' . $rows, $val->referredToCustomerName);
                $sheet->setCellValue('M' . $rows, $val->referredToMobile);
                $sheet->setCellValue('N' . $rows, $val->referredToAmount);
                $rows++;
            }

            $Excel_writer = new Xls($spreadSheet);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="referral-report.xls"');
            header('Cache-Control: max-age=0');
            ob_end_clean();
            $Excel_writer->save('php://output');
            exit();
        } catch (Exception $e) {
            Log::info('referral report export error : ' . $e);
        }
    }
}
