<?php

namespace App\Exports;

use Log;
use PhpOffice\PhpSpreadsheet\Reader\Exception;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xls;
use Carbon\Carbon;

class ProgramwiseDetailReportExport
{

    public $excelEntities;

    public function __construct(ExcelEntities $excelEntities)
    {
        $this->excelEntities = $excelEntities;
    }

    public function exportExcel($request, $data)
    {

        ob_start();
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '4000M');

        try {

            $spreadSheet = new Spreadsheet();

            $sheet = $spreadSheet->getActiveSheet();

            $bold = $this->excelEntities->styleBold();
            $heading = $this->excelEntities->styleHeading1();

            $sheet->setCellValue('A1', 'Date Range : ' .$request->fromDateLabel . ' to ' . $request->toDateLabel);
            $sheet->setCellValue('A2', 'Scheme : '. $request->schemeLabel);
            $sheet->setCellValue('A3', 'Program : '. $request->programLabel);
            $sheet->setCellValue('A4', 'District : '. $request->districtLabel);
            $sheet->setCellValue('A5', 'Block : '. $request->blockLabel);
            $sheet->setCellValue('A6', 'Result By : '. $request->fieldType);

            $sheet->setCellValue('A8', 'Feedback ID');
            $sheet->setCellValue('B8', 'Ben Name');
            $sheet->setCellValue('C8', 'Mobile');
            $sheet->setCellValue('D8', 'Scheme');
            $sheet->setCellValue('E8', 'Program');
            $sheet->setCellValue('F8', 'District');
            $sheet->setCellValue('G8', 'Block');
            $sheet->setCellValue('H8', 'Sector');
            $sheet->setCellValue('I8', 'AWC');
            $sheet->setCellValue('J8', 'Complaint Registered');
            $sheet->setCellValue('K8', 'Call By');
            $sheet->setCellValue('L8', 'Call Date');

            $sheet->getStyle('A1')->applyFromArray($heading);
            $sheet->getStyle('A2')->applyFromArray($heading);
            $sheet->getStyle('A3')->applyFromArray($heading);
            $sheet->getStyle('A4')->applyFromArray($heading);
            $sheet->getStyle('A5')->applyFromArray($heading);
            $sheet->getStyle('A6')->applyFromArray($heading);

            $sheet->getStyle('A8:L8')->applyFromArray($bold);

            $rows = 9;

            foreach ($data as $key => $val) {

                $sheet->setCellValue('A' . $rows, $val->feedback_no);
                $sheet->setCellValue('B' . $rows, $val->parent_name);
                $sheet->setCellValue('C' . $rows, $val->mobile_number);
                $sheet->setCellValue('D' . $rows, $val->scheme);
                $sheet->setCellValue('E' . $rows, $val->program);
                $sheet->setCellValue('F' . $rows, $val->district);
                $sheet->setCellValue('G' . $rows, $val->block);
                $sheet->setCellValue('H' . $rows, $val->sector_name);
                $sheet->setCellValue('I' . $rows, $val->awc_name);
                $sheet->setCellValue('J' . $rows, $val->complaint_registered);
                $sheet->setCellValue('K' . $rows, $val->call_user);
                $sheet->setCellValue('L' . $rows, AppDateTimeFormat($val->created_at));
                $rows++;

            }

            $Excel_writer = new Xls($spreadSheet);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="dashboard-report.xls"');
            header('Cache-Control: max-age=0');
            ob_end_clean();
            $Excel_writer->save('php://output');
            exit();

        } catch (Exception $e) {

            Log::info('dashboard report export error : ' . $e);

        }

    }
}
