<?php

namespace App\Exports;

use Log;
use PhpOffice\PhpSpreadsheet\Reader\Exception;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xls;
use Carbon\Carbon;

class NologinNocallsExport
{

    public $excelEntities;

    public function __construct(ExcelEntities $excelEntities)
    {
        $this->excelEntities = $excelEntities;
    }

    public function exportExcel($request, $data)
    {
        ob_start();
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '4000M');

        try {

            $spreadSheet = new Spreadsheet();

            $sheet = $spreadSheet->getActiveSheet();

            $bold = $this->excelEntities->styleBold();
            $heading = $this->excelEntities->styleHeading1();

            $sheet->setCellValue('A1', 'Date Range : ' . Carbon::parse($request->fromDate)->format('d/m/Y') . ' to ' . Carbon::parse($request->toDate)->format('d/m/Y'));
            $sheet->setCellValue('A2', 'Branch : ' . $request->branchLabel);

            $sheet->setCellValue('A3', 'Branch');
            $sheet->setCellValue('B3', 'No of Users');
            $sheet->setCellValue('C3', 'No of Logins');
            $sheet->setCellValue('D3', 'No of Calls Allocated');
            $sheet->setCellValue('E3', 'No of Calls Dialled');
            $sheet->setCellValue('F3', 'Connected Calls');
            $sheet->setCellValue('G3', 'Not Connected Calls');

            $sheet->getStyle('A1')->applyFromArray($heading);
            $sheet->getStyle('A2')->applyFromArray($heading);
            $sheet->getStyle('A3')->applyFromArray($heading);

            $sheet->getStyle('A5:G3')->applyFromArray($bold);

            $rows = 4;
            
            foreach ($data as $key => $val) {
         
                $sheet->setCellValue('A' . $rows, $val->name);
                $sheet->setCellValue('B' . $rows, $val->usersCount);
                $sheet->setCellValue('C' . $rows, $val->loginCount);
                $sheet->setCellValue('D' . $rows, $val->allocatedCalls);
                $sheet->setCellValue('E' . $rows, $val->dialledCalls);
                $sheet->setCellValue('F' . $rows, $val->connectedCalls);
                $sheet->setCellValue('G' . $rows, $val->notConnectedCalls);
                $rows++;
            }

            $Excel_writer = new Xls($spreadSheet);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="nologin-nocalls-report.xls"');
            header('Cache-Control: max-age=0');
            ob_end_clean();
            $Excel_writer->save('php://output');
            exit();
        } catch (Exception $e) {
            Log::info('nologin-nocalls report export error : ' . $e);
        }
    }

}
