<?php

namespace App\Exports;

use Log;
use PhpOffice\PhpSpreadsheet\Reader\Exception;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xls;
use Carbon\Carbon;

class CallsDialledReportExcel
{

    public $excelEntities;

    public function __construct(ExcelEntities $excelEntities)
    {
        $this->excelEntities = $excelEntities;
    }

    public function exportExcel($request, $data)
    {
        $groupedData = $data->groupBy('source');

        ob_start();
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '4000M');

        try {

            $spreadSheet = new Spreadsheet();
            $bold = $this->excelEntities->styleBold();
            $heading = $this->excelEntities->styleHeading1();
            $firstSheet = true;

            foreach ($groupedData as $key => $gData) {

                if ($firstSheet) {
                    $sheet = $spreadSheet->getActiveSheet();
                    $firstSheet = false;
                } else {
                    $sheet = $spreadSheet->createSheet();
                }
                $sheet->setTitle($key);
                $spreadSheet->setActiveSheetIndexByName($key);

                $sheet->setCellValue('A1', 'Date Range : ' . Carbon::parse($request->fromDate)->format('d/m/Y') . ' to ' . Carbon::parse($request->toDate)->format('d/m/Y'));
                $sheet->setCellValue('A2', 'Cluster : ' . $request->clusterLabel);
                $sheet->setCellValue('A3', 'Branch : ' . $request->branchLabel);
                $sheet->setCellValue('A4', 'Agent : ' . $request->agentLabel);

                $sheet->setCellValue('A5', 'Cluster');
                $sheet->setCellValue('B5', 'Branch');
                $sheet->setCellValue('C5', 'Date');
                $sheet->setCellValue('D5', 'Source');
                $sheet->setCellValue('E5', 'Percentage');
                $sheet->setCellValue('F5', 'Agent Name');
                $sheet->setCellValue('G5', 'Designation');
                $sheet->setCellValue('H5', 'Class');
                $sheet->setCellValue('I5', 'Employee ID');
                $sheet->setCellValue('J5', 'Attendance');
                $sheet->setCellValue('K5', 'Login Time');
                $sheet->setCellValue('L5', 'Logout Time');
                $sheet->setCellValue('M5', 'Campaign Name');
                $sheet->setCellValue('N5', 'Date');
                $sheet->setCellValue('O5', 'Customer Name');
                $sheet->setCellValue('P5', 'Mobile No');
                $sheet->setCellValue('Q5', 'Description');
                $sheet->setCellValue('R5', 'Call Date Time');
                $sheet->setCellValue('S5', 'Call Duration');
                $sheet->setCellValue('T5', 'Talk Duration');
                $sheet->setCellValue('U5', 'ACW');
                $sheet->setCellValue('V5', 'Disposition 1');
                $sheet->setCellValue('W5', 'Disposition 2');
                $sheet->setCellValue('X5', 'Disposition 3');
                $sheet->setCellValue('Y5', 'Callback Date');
                $sheet->setCellValue('Z5', 'Callback Time');
                $sheet->setCellValue('AA5', 'Ticket No');

                $sheet->getStyle('A1')->applyFromArray($heading);
                $sheet->getStyle('A2')->applyFromArray($heading);
                $sheet->getStyle('A3')->applyFromArray($heading);
                $sheet->getStyle('A4')->applyFromArray($heading);

                $sheet->getStyle('A5:AA5')->applyFromArray($bold);

                $rows = 6;

                foreach ($gData as $val) {

                    $customerName = preg_replace('/[^\x20-\x7E]/', '', $val->customer_name);

                    $sheet->setCellValue('A' . $rows, $val->clusterName);
                    $sheet->setCellValue('B' . $rows, $val->branchName);
                    $sheet->setCellValue('C' . $rows, $val->callDate);
                    $sheet->setCellValue('D' . $rows, $val->source);
                    $sheet->setCellValue('E' . $rows, $val->percentage);
                    $sheet->setCellValue('F' . $rows, $val->agentName);
                    $sheet->setCellValue('G' . $rows, $val->designationName);
                    $sheet->setCellValue('H' . $rows, $val->className);
                    $sheet->setCellValue('I' . $rows, $val->agentId);
                    $sheet->setCellValue('J' . $rows, $val->attendance);
                    $sheet->setCellValue('K' . $rows, $val->login_in);
                    $sheet->setCellValue('L' . $rows, $val->log_out);
                    $sheet->setCellValue('M' . $rows, $val->campaignName);
                    $sheet->setCellValue('N' . $rows, $val->campaignDate);
                    $sheet->setCellValue('O' . $rows, $customerName);
                    $sheet->setCellValue('P' . $rows, $val->mobile_number);
                    $sheet->setCellValue('Q' . $rows, $val->description);
                    $sheet->setCellValue('R' . $rows, $val->callDateTime);
                    $sheet->setCellValue('S' . $rows, $val->call_duration);
                    $sheet->setCellValue('T' . $rows, $val->call_transfer_duration);
                    $sheet->setCellValue('U' . $rows, $val->acw);
                    $sheet->setCellValue('V' . $rows, $val->callStatus);
                    $sheet->setCellValue('W' . $rows, $val->dispositions);
                    $sheet->setCellValue('X' . $rows, $val->callReason);
                    $sheet->setCellValue('Y' . $rows, $val->callbackDate);
                    $sheet->setCellValue('Z' . $rows, $val->callbackTime);
                    $sheet->setCellValue('AA' . $rows, $val->ticketNo);
                    $rows++;
                }
            }

            $spreadSheet->setActiveSheetIndex(0);
            $Excel_writer = new Xls($spreadSheet);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="calls-dialled-report.xls"');
            header('Cache-Control: max-age=0');
            ob_end_clean();
            $Excel_writer->save('php://output');
            exit();
        } catch (Exception $e) {
            Log::info('calls dialled report export error : ' . $e);
        }
    }
}
