<?php

namespace App\Exports;

use Log;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xls;
use Carbon\Carbon;
use Exception;

class CallMappingExport
{
    public $excelEntities;

    public function __construct(ExcelEntities $excelEntities)
    {
        $this->excelEntities = $excelEntities;
    }

    public function exportExcel($data)
    {
        ob_start();
        ini_set('max_execution_time', 0);
        ini_set('memory_limit', '4000M');

        try {
            $spreadSheet = new Spreadsheet();

            // First Sheet
            $sheet1 = $spreadSheet->getActiveSheet();
            $sheet1->setTitle('Assigned'); // Set the title of the first sheet
            $assigned = $data->items;
            $this->populateSheet($sheet1, $data, $assigned);

            // Second Sheet
            $sheet2 = $spreadSheet->createSheet();
            $sheet2->setTitle('Unassigned'); // Set the title of the second sheet
            $unassigned = $data->unAssigned;
            $this->populateSheet($sheet2, $data, $unassigned);

            $Excel_writer = new Xls($spreadSheet);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="call-mapping-report.xls"');
            header('Cache-Control: max-age=0');
            ob_end_clean();
            $Excel_writer->save('php://output');
            exit();
        } catch (Exception $e) {
            Log::info('just dial report export error : ' . $e);
        }
    }

    private function populateSheet($sheet, $mapping, $data)
    {
        $bold = $this->excelEntities->styleBold();
        $heading = $this->excelEntities->styleHeading1();

        // Set headers
        $sheet->setCellValue('A1', 'Mapping No : ' . $mapping->mapping_no);
        $sheet->setCellValue('A2', 'Branch : ' . $mapping->branchName);
        $sheet->setCellValue('A3', 'Date : ' . $mapping->date);
        $sheet->setCellValue('A4', 'User : ' . $mapping->createdUser);

        $sheet->setCellValue('A5', 'Agent Name');
        $sheet->setCellValue('B5', 'Customer Name');
        $sheet->setCellValue('C5', 'Mobile');
        $sheet->setCellValue('D5', 'Description');

        $sheet->getStyle('A1')->applyFromArray($heading);
        $sheet->getStyle('A2')->applyFromArray($heading);
        $sheet->getStyle('A3')->applyFromArray($heading);
        $sheet->getStyle('A4')->applyFromArray($heading);
        $sheet->getStyle('A5:K5')->applyFromArray($bold);

        $rows = 6;
        foreach ($data as $key => $val) {
            $sheet->setCellValue('A' . $rows, $val->agentName);
            $sheet->setCellValue('B' . $rows, $val->customer_name);
            $sheet->setCellValue('C' . $rows, $val->mobile_number);
            $sheet->setCellValue('D' . $rows, $val->description);
            $rows++;
        }
    }
}
