<?php

namespace App\Console\Commands;

use App\Services\Transactions\InterestCallAllocationService;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Log;

class InterestCallAllocationCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'allocate:interest';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'allocate already spoken interest calls';

    /**
     * Execute the console command.
     *
     * @return int
     */

    public $autoCallAllocationService;

    public function handle(InterestCallAllocationService $interestCallAllocationService)
    {
        Log::info('interest call allocation started : ' . Carbon::now());
        $interestCallAllocationService->allocateData();
        Log::info('interest call allocation end : ' . Carbon::now());
    }
}
