<?php

namespace App\Console\Commands;

use App\Services\ImportCouponCodeService;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Log;

class ImportCouponCodeCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'import:coupon';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command for importing coupon code';

    /**
     * Execute the console command.
     *
     * @return int
     */
    private $importCouponCodeService;

    public function handle(ImportCouponCodeService $importCouponCodeService)
    {
        Log::info('import coupon code started : ' . Carbon::now());
        // for importing referral vouchers codes
        $importCouponCodeService->importData();
        //for importing referrer voucher codes
        // $importCouponCodeService->importReferrerData();
        Log::info('import coupon code end : ' . Carbon::now());
    }
}
