<?php

namespace App\Console\Commands;

use App\Services\Transactions\GreytHrService;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Log;

class GreytHrCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'fetch:graythr';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command for fetching data from greythr software';

    /**
     * Execute the console command.
     *
     * @return int
     */
    private $greytHrService;

    public function handle(GreytHrService $greytHrService)
    {
        // Log::info('graythr fetching company 1 started : ' . Carbon::now());
        // //for getting promoters
        // $greytHrService->fetchData(1);
        // Log::info('graythr fetching company 1 end : ' . Carbon::now());
        Log::info('graythr fetching company 2 started : ' . Carbon::now());
        //for getting staffs
        $greytHrService->fetchData(2);
        Log::info('graythr fetching company 2 end : ' . Carbon::now());
    }
}
