<?php

namespace App\Console\Commands;

use App\Services\ExcelCampaignService;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Log;

class ExcelCampaignCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'excel:campaign';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'get data from excel and create leads';

    /**
     * Execute the console command.
     *
     * @return int
     */
    private $excelCampaignService;

    public function handle(ExcelCampaignService $excelCampaignService)
    {
        Log::info('excel campaign fetch started : ' . Carbon::now());
        $excelCampaignService->startFetching();
        Log::info('excel campaign fetch end : ' . Carbon::now());
    }
}
