<?php

namespace App\Console\Commands;

use App\Services\AudioScriptAnalysisService;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Log;

class AudioScriptAnalysisCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'audio:process';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'its is used to analysis the audio script and given the output';

    /**
     * Execute the console command.
     *
     * @return int
     */
    private $audioScriptAnalysisService;

    public function handle(AudioScriptAnalysisService $audioScriptAnalysisService)
    {
        Log::info('script analysing started : ' . Carbon::now());
        $audioScriptAnalysisService->fetchData();
        Log::info('script analysing end : ' . Carbon::now());
    }
}
